function[chivv,pval,ord] = TerM(data,N,pmax)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Section 4.5 
% file: TerM.m
%
% Terdik-Math test statistic for linearity. 
% 
% INPUT:
% data   = time series data of length n
% N      = stretch length (e.g. 2^{x}) <= n
%          So the end of the series is usually left out.
%          To avoid this loss, the program also investigates the
%          shifted series of the same length. This may take some 
%          time. So it gives a vector of p-values.       
% pmax   = maximum AR order
% ord    = AR order 
%
% OUTPUT:
% chivv  = vector of test statistics
% pval   = vector of p-values
% 
% Reference: 
% Terdik, G. and M\'{a}th, J. (1998).
%   A new test of linearity of time series based on the bispectrum.
%   Journal of Time Series Analysis, 19(6), 737-753.
%   DOI: 10.1111/1467-9892.00120.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
window = 8;  % default
fed    = 0;

x  = zscore(data);  
n  = length(x);                           
K  = fix((n-N*fed/100)/N/(100-fed)*100 );   % Number of stretches        
NN = K*N; % Length of the series under investigation: 2^{x} * K 
 
darab = n-NN-1; % Number of shifted series
pval  = zeros(1,darab);

for j=1:darab;
   y = x(j:j+NN+1); 
   [~,A,C,SBC,FPE,th] = arfit(y,1,pmax); % AR order 
   [m,order]  = size(A);
   order      = order+1;
   ord(j,1)   = order;   
   e          = filter(A,1,y);  
   stde       = std(e);
   e          = e/stde;
   bisp       = bispwin(e,N,window, fed); % Estimated bispectrum
   chi_val    = StatTerM(bisp,n,N,window,fed);
   chivv(j)   = chi_val;
   pval(j)    = 1-chi2cdf(chi_val,14);  %  14 = 2 * 7  with 7 triplets 
end;
